# 🚀 Quick Start Guide

## Installation (3 steps)

### 1️⃣ Upload files to server
```bash
scp *.py *.txt *.sh *.service README.md root@167.71.178.31:/root/
```

### 2️⃣ SSH into server and run setup
```bash
ssh root@167.71.178.31
cd /root
chmod +x setup.sh install_service.sh
./setup.sh
```

### 3️⃣ Install and start the bot service
```bash
cd /home/tradingbot
./install_service.sh
```

✅ **Done!** Your bot is now running 24/7.

---

## Daily Usage

### Check bot status
```bash
sudo systemctl status tradingbot
```

### View live logs
```bash
sudo journalctl -u tradingbot -f
```

### Today's performance
```bash
cd /home/tradingbot
source venv/bin/activate
python3 daily_analysis.py
```

### Monitor stats
```bash
/home/tradingbot/monitor.sh
```

### Restart bot
```bash
sudo systemctl restart tradingbot
```

---

## Log Files

Daily JSON logs stored in: `/home/tradingbot/logs/`

Format: `bot_log_YYYY-MM-DD.json`

Example:
```bash
# View today's log
tail -f /home/tradingbot/logs/bot_log_$(date +%Y-%m-%d).json

# List all logs
ls -lh /home/tradingbot/logs/
```

---

## Troubleshooting

### Bot not running?
```bash
sudo systemctl status tradingbot
sudo journalctl -u tradingbot -n 50
```

### Check errors
```bash
tail -50 /home/tradingbot/logs/bot_error.log
```

### Manual run (debugging)
```bash
cd /home/tradingbot
source venv/bin/activate
python3 run.py
```

---

**Support:** Check README.md for detailed documentation
