# 🤖 Trading Bot - הוראות התקנה ל-Digital Ocean

## 📋 מפרט השרת שלך
- **IP**: 167.71.178.31
- **מיקום**: NYC3
- **זיכרון**: 1 GB
- **דיסק**: 25 GB
- **מערכת הפעלה**: Ubuntu 24.04

---

## 🚀 התקנה מהירה

### שלב 1: התחברות לשרת

```bash
ssh root@167.71.178.31
```

### שלב 2: העלאת קבצים

העתק את כל הקבצים הבאים לשרת:
- `engine.py`
- `indicators.py`
- `mempool.py`
- `run.py`
- `logger.py`
- `requirements.txt`
- `setup.sh`
- `install_service.sh`
- `tradingbot.service`

**באמצעות SCP מהמחשב המקומי:**
```bash
scp *.py requirements.txt setup.sh install_service.sh tradingbot.service root@167.71.178.31:/root/
```

או **באמצעות SFTP/FTP client** כמו FileZilla.

### שלב 3: הרצת סקריפט ההתקנה

```bash
cd /root
chmod +x setup.sh install_service.sh
./setup.sh
```

הסקריפט יבצע:
- ✅ עדכון המערכת
- ✅ התקנת Python 3 ו-pip
- ✅ יצירת תיקיית `/home/tradingbot`
- ✅ התקנת כל ה-dependencies
- ✅ הכנת סביבת הפעלה

### שלב 4: התקנת Service (אוטומטי)

```bash
cd /home/tradingbot
./install_service.sh
```

הבוט יתחיל לרוץ אוטומטית! ✨

---

## 📊 ניהול הבוט

### בדיקת סטטוס
```bash
sudo systemctl status tradingbot
```

### צפייה בלוגים בזמן אמת
```bash
sudo journalctl -u tradingbot -f
```

### הפעלה מחדש
```bash
sudo systemctl restart tradingbot
```

### עצירת הבוט
```bash
sudo systemctl stop tradingbot
```

### הפעלת הבוט
```bash
sudo systemctl start tradingbot
```

---

## 📁 מבנה תיקיות

```
/home/tradingbot/
├── venv/              # Python virtual environment
├── logs/              # לוגים יומיים
│   ├── bot_log_2025-01-15.json
│   ├── bot_log_2025-01-16.json
│   ├── bot_output.log
│   └── bot_error.log
├── engine.py
├── indicators.py
├── mempool.py
├── run.py
├── logger.py
└── requirements.txt
```

---

## 📝 לוגים

### לוגים יומיים (JSON)
כל יום נשמר בקובץ נפרד:
```bash
ls -lh /home/tradingbot/logs/bot_log_*.json
```

### צפייה בלוג של היום
```bash
tail -f /home/tradingbot/logs/bot_log_$(date +%Y-%m-%d).json
```

### לוגים של ה-Service
```bash
# Output logs
tail -f /home/tradingbot/logs/bot_output.log

# Error logs
tail -f /home/tradingbot/logs/bot_error.log
```

---

## 🔧 הרצה ידנית (ללא Service)

אם אתה רוצה להריץ את הבוט ידנית:

```bash
cd /home/tradingbot
source venv/bin/activate
python3 run.py
```

לעצירה: `Ctrl+C`

---

## 🛠️ פתרון בעיות

### הבוט לא פועל
```bash
# בדוק סטטוס
sudo systemctl status tradingbot

# בדוק לוגים
sudo journalctl -u tradingbot -n 50

# הפעל מחדש
sudo systemctl restart tradingbot
```

### בעיות רשת
```bash
# בדוק חיבור לאינטרנט
ping -c 3 api.binance.com

# בדוק חיבור ל-mempool
curl https://mempool.space/api/mempool
```

### בעיות Python
```bash
cd /home/tradingbot
source venv/bin/activate
python3 -c "import aiohttp, numpy, requests; print('OK')"
```

### ניקוי לוגים ישנים
הבוט שומר לוגים ל-30 יום. לשינוי, ערוך את `logger.py`:
```python
cleanup_old_logs(days_to_keep=30)  # שנה למספר הימים הרצוי
```

---

## 📈 מעקב אחר ביצועים

### CPU & Memory
```bash
htop
```

### שימוש בדיסק
```bash
df -h
du -sh /home/tradingbot/logs/
```

### כמות טריידים
```bash
grep -o '"exec_side": "OPEN_LONG"' /home/tradingbot/logs/*.json | wc -l
```

---

## 🔐 אבטחה

### שינוי סיסמת Root (מומלץ!)
```bash
passwd
```

### הגדרת Firewall
```bash
sudo ufw allow OpenSSH
sudo ufw enable
sudo ufw status
```

### עדכוני אבטחה אוטומטיים
```bash
sudo apt-get install unattended-upgrades
sudo dpkg-reconfigure --priority=low unattended-upgrades
```

---

## 📞 תמיכה

אם יש בעיות:
1. בדוק את הלוגים: `sudo journalctl -u tradingbot -n 100`
2. ודא שהשרת מחובר לאינטרנט
3. ודא שיש מספיק זיכרון פנוי: `free -h`
4. בדוק שימוש בדיסק: `df -h`

---

## 🎯 טיפים

### הרצת בדיקה מהירה
```bash
cd /home/tradingbot
source venv/bin/activate
python3 -c "from engine import detect_signal; print('Engine OK')"
```

### גיבוי לוגים
```bash
# יצירת ארכיון של כל הלוגים
tar -czf logs_backup_$(date +%Y%m%d).tar.gz /home/tradingbot/logs/

# העברה למחשב המקומי
scp root@167.71.178.31:/root/logs_backup_*.tar.gz ./
```

### מעקב אוטומטי אחר הסטטוס
הוסף ל-crontab:
```bash
crontab -e
```

הוסף שורה:
```
0 * * * * systemctl is-active tradingbot || systemctl restart tradingbot
```

זה יבדוק כל שעה אם הבוט פעיל, ואם לא - יפעיל אותו מחדש.

---

## ✅ רשימת בדיקה מהירה

- [ ] התחברת לשרת בהצלחה
- [ ] העלית את כל הקבצים
- [ ] הרצת `setup.sh`
- [ ] הרצת `install_service.sh`
- [ ] הבוט פעיל: `systemctl status tradingbot`
- [ ] נוצרו לוגים: `ls /home/tradingbot/logs/`
- [ ] הבוט עושה טריידים (בדוק בלוגים)

---

**בהצלחה! 🚀📈**
