#!/bin/bash
# התקנת systemd service להפעלה אוטומטית של הבוט

set -e

echo "🔧 מתקין Trading Bot Service..."

# העתקת service file
sudo cp tradingbot.service /etc/systemd/system/

# טעינת service חדש
sudo systemctl daemon-reload

# הפעלת service
sudo systemctl enable tradingbot.service
sudo systemctl start tradingbot.service

echo ""
echo "✅ Service הותקן והופעל בהצלחה!"
echo ""
echo "📋 פקודות ניהול:"
echo "   סטטוס:          sudo systemctl status tradingbot"
echo "   עצירה:          sudo systemctl stop tradingbot"
echo "   הפעלה:          sudo systemctl start tradingbot"
echo "   הפעלה מחדש:     sudo systemctl restart tradingbot"
echo "   לוגים בזמן אמת: sudo journalctl -u tradingbot -f"
echo "   ביטול אוטומטי:  sudo systemctl disable tradingbot"
echo ""
echo "📊 צפייה בלוגים יומיים:"
echo "   ls -lh /home/tradingbot/logs/"
echo ""
