#!/bin/bash
# סקריפט ניטור - מציג סטטיסטיקות של הבוט

BOT_DIR="/home/tradingbot"
LOGS_DIR="${BOT_DIR}/logs"

echo "📊 Bot Status Monitor"
echo "===================="
echo ""

# בדיקת service
echo "🔧 Service Status:"
systemctl is-active tradingbot >/dev/null 2>&1 && echo "   ✅ Running" || echo "   ❌ Stopped"
echo ""

# סטטיסטיקות לוגים
echo "📁 Logs Statistics:"
if [ -d "$LOGS_DIR" ]; then
    LOG_COUNT=$(ls -1 ${LOGS_DIR}/bot_log_*.json 2>/dev/null | wc -l)
    echo "   Log files: ${LOG_COUNT}"
    
    TOTAL_SIZE=$(du -sh ${LOGS_DIR} 2>/dev/null | cut -f1)
    echo "   Total size: ${TOTAL_SIZE}"
    
    # מציאת הלוג האחרון
    LATEST_LOG=$(ls -t ${LOGS_DIR}/bot_log_*.json 2>/dev/null | head -1)
    if [ -n "$LATEST_LOG" ]; then
        echo "   Latest: $(basename $LATEST_LOG)"
        
        # ספירת טריידים
        OPEN_TRADES=$(grep -o '"exec_side": "OPEN_LONG"' "$LATEST_LOG" 2>/dev/null | wc -l)
        CLOSE_TRADES=$(grep -o '"exec_side": "CLOSE_LONG"' "$LATEST_LOG" 2>/dev/null | wc -l)
        echo "   Today's trades: ${OPEN_TRADES} opened, ${CLOSE_TRADES} closed"
    fi
else
    echo "   ⚠️  Logs directory not found"
fi
echo ""

# שימוש במשאבים
echo "💻 Resource Usage:"
echo "   Memory: $(free -h | awk '/Mem:/ {print $3 " / " $2}')"
echo "   Disk: $(df -h ${BOT_DIR} | awk 'NR==2 {print $3 " / " $2 " (" $5 " used)"}')"
echo ""

# לוגים אחרונים
echo "📝 Last 5 Log Entries:"
if [ -n "$LATEST_LOG" ]; then
    tail -5 "$LATEST_LOG" 2>/dev/null | grep -o '"action": "[^"]*"' | tail -5
else
    echo "   No logs available"
fi
echo ""

# תקלות אחרונות
echo "⚠️  Recent Errors (if any):"
ERROR_LOG="${LOGS_DIR}/bot_error.log"
if [ -f "$ERROR_LOG" ] && [ -s "$ERROR_LOG" ]; then
    tail -3 "$ERROR_LOG"
else
    echo "   ✅ No errors"
fi
echo ""

echo "===================="
echo "💡 Useful commands:"
echo "   Status:   sudo systemctl status tradingbot"
echo "   Logs:     sudo journalctl -u tradingbot -f"
echo "   Restart:  sudo systemctl restart tradingbot"
echo ""
