#!/bin/bash
# התקנה אוטומטית של הבוט על Digital Ocean

set -e

echo "🚀 התחלת התקנת Trading Bot..."

# עדכון מערכת
echo "📦 מעדכן את המערכת..."
sudo apt-get update
sudo apt-get upgrade -y

# התקנת Python 3 ו-pip
echo "🐍 מתקין Python3 ו-pip..."
sudo apt-get install -y python3 python3-pip python3-venv

# יצירת תיקיית הבוט
BOT_DIR="/home/tradingbot"
echo "📁 יוצר תיקיית בוט ב-${BOT_DIR}..."
sudo mkdir -p ${BOT_DIR}
sudo chown -R $USER:$USER ${BOT_DIR}

# העתקת קבצים
echo "📄 מעתיק קבצים..."
cp *.py ${BOT_DIR}/
cp requirements.txt ${BOT_DIR}/

cd ${BOT_DIR}

# יצירת virtual environment
echo "🔧 יוצר virtual environment..."
python3 -m venv venv

# הפעלת venv והתקנת חבילות
echo "📚 מתקין dependencies..."
source venv/bin/activate
pip install --upgrade pip
pip install -r requirements.txt

# יצירת תיקיית לוגים
mkdir -p logs

echo ""
echo "✅ ההתקנה הושלמה בהצלחה!"
echo ""
echo "📋 פקודות שימושיות:"
echo "   להפעלת הבוט:     cd ${BOT_DIR} && source venv/bin/activate && python3 run.py"
echo "   לצפייה בלוגים:   ls -lh ${BOT_DIR}/logs/"
echo "   להתקנת service:  sudo ./install_service.sh"
echo ""
